
clear all
set more off
set memory 500m
set matsize 800

use "Data.dta"

* subjects and rounds by treatment
gen counting=1
collapse (sum) counting, by(prior id)
table prior, contents(count counting sum counting) col row

clear all
use "Data.dta"

* Identify speed of rounds
gen quick_flag=0
replace quick_flag=1 if submit<=8

* Table 1: Percent of rounds first option chosen
table prior quick_flag, contents(mean position_1_choice) col row

* Percent of rounds best option chosen (automatic rounds)
table prior block if quick_flag==1, contents(count choice_best mean choice_best) col row

* Table 2: Percent of rounds best option chosen (considered rounds)
table prior block if quick_flag==0, contents(count choice_best mean choice_best) col row

* Table 3: Percent of automatic decisions by treatment
table prior block, contents(mean quick_flag) col row

clear all
use "Data.dta"

* Identify speed of rounds
gen quick_flag=0
replace quick_flag=1 if submit<=8

* Consideration time
table quick_flag choice_best, contents(mean submit median submit sd submit) col row
table quick_flag choice_best, contents(p10 submit p30 submit p50 submit) col row
table quick_flag choice_best, contents(p70 submit p90 submit) col row

* Figure 3. Histogram of decision times
hist submit, bin(70) fraction yscale(range(0 .5)) addplot(pci 0 8 .5 8) legend(off) xtitle(Decision time) scheme(s2mono)

* Figure 4. Histogram of decision times (<=12)
hist submit if submit<=12, discrete fraction yscale(range(0 .5)) xscale(range(0 12)) xlabel(1(1)12) addplot(pci 0 8.5 .5 8.5) legend(off) xtitle(Decision time) scheme(s2mono)

* Table 1: Percent of rounds first option chosen
table prior quick_flag, contents(mean position_1_choice) col row

* Percent of rounds best option chosen (automatic rounds)
table prior block if quick_flag==1, contents(count choice_best mean choice_best) col row

* Significant difference (t-test)
prtest choice_best if (prior==33 | prior==40) & quick_flag==1, by(prior)
prtest choice_best if (prior==33 | prior==50) & quick_flag==1, by(prior)
prtest choice_best if (prior==40 | prior==50) & quick_flag==1, by(prior)

* Table 2: Percent of rounds best option chosen (considered rounds)
table prior block if quick_flag==0, contents(count choice_best mean choice_best) col row

* Significant difference (t-test)
prtest choice_best if (prior==33 | prior==40) & quick_flag==0, by(prior)
prtest choice_best if (prior==33 | prior==50) & quick_flag==0, by(prior)
prtest choice_best if (prior==40 | prior==50) & quick_flag==0, by(prior)

* Table 3: Percent of automatic decisions by treatment
table prior block, contents(mean quick_flag) col row

* Significant difference (t-test)
prtest quick_flag if (prior==33 | prior==40), by(prior)
prtest quick_flag if (prior==33 | prior==50), by(prior)
prtest quick_flag if (prior==40 | prior==50), by(prior)


